/**
 * define MoreMouseGestureOptions
 *
 ***/
cr.define('options', function() {
  var OptionsPage = options.OptionsPage;

  function TpMoreMouseGestureOptions() {
    //OptionsPage.call(this, 'tpMoreMouseGesture', templateData.IDS_MORE_SETTING_DLG_SETTING, 'tpMoreMouseGesturePage');
    OptionsPage.call(this, 'tpMoreMouseGesture', templateData.mouseGesturePageTabTitle, 'tpMoreMouseGesturePage');
  }

  cr.addSingletonGetter(TpMoreMouseGestureOptions);

  TpMoreMouseGestureOptions.prototype = {
    __proto__: options.OptionsPage.prototype,

    initializePage: function() {

      OptionsPage.prototype.initializePage.call(this);

      $('IDS_MORE_GESTURE_RESTORE_DEFAULT').onclick = function() {
        if (confirm($('IDS_MORE_GESTURE_RESTORE_DEFAULT_CONFIRM').innerText))
          chrome.send('gestureRestoreDefault');
      };
      this.buildList();
      this.addEventListener('visibleChange', function(event) {
        try {
          if (!this.visible) return;
          tpGetInitOptionsData();
          UpdateMouseGeture();
        } catch (e) {
          //OptionsPage.showDefaultPage();
        }
      });

    },

    buildList: function() {
      for (var key in tpInitOptionsMouseGestureData) {
        var item = tpInitOptionsMouseGestureData[key],
          liEl = document.createElement('li'),
          iEl = document.createElement('i'),
          spanEl = document.createElement('span'),
          divEl = document.createElement('div'),
          selectEl = document.createElement('select');
        iEl.style.backgroundPosition = item.pos;
        if (item.title) {
          iEl.style.marginTop = "8px";
          iEl.title = item.title;
        }
        liEl.appendChild(iEl);
        spanEl.innerHTML = templateData[key];
        liEl.appendChild(spanEl);
        selectEl.id = 'SELECT_' + key;
        divEl.appendChild(selectEl);
        liEl.appendChild(divEl);
        $('tpMoreMouseGestureList').appendChild(liEl);
      }
    }
  }

  return {
    TpMoreMouseGestureOptions: TpMoreMouseGestureOptions
  };
});

function gestureRestoreDefaultCallback() {
  for (var key in tpInitOptionsMouseGestureData) {
    var selectEl = $('SELECT_' + key);
    selectEl.value = tpInitOptionsMouseGestureData[key].defaultVal;
  }
  updateTips();
}
tpInitOptionsMouseGestureData = {
  'IDS_MORE_SETTING_DLG_U': {
    "pos": "-3px -1px",
    "defaultVal": 1
  },
  'IDS_MORE_SETTING_DLG_UD': {
    "pos": "-47px 0",
    "defaultVal": 6
  },
  'IDS_MORE_SETTING_DLG_D': {
    "pos": "-2px -49px",
    "defaultVal": 2
  },
  'IDS_MORE_SETTING_DLG_DU': {
    "pos": "-47px -49px",
    "defaultVal": 5
  },
  'IDS_MORE_SETTING_DLG_L': {
    "pos": "-1px -97px",
    "defaultVal": 7
  },
  'IDS_MORE_SETTING_DLG_RU': {
    "pos": "-47px -95px",
    "defaultVal": 10
  },
  'IDS_MORE_SETTING_DLG_R': {
    "pos": "0 -145px",
    "defaultVal": 8
  },
  'IDS_MORE_SETTING_DLG_RD': {
    "pos": "-47px -145px",
    "defaultVal": 9
  },
  'IDS_MORE_SETTING_DLG_UL': {
    "pos": "-1px -193px",
    "defaultVal": 17
  },
  'IDS_MORE_SETTING_DLG_LU': {
    "pos": "-47px -191px",
    "defaultVal": 0
  },
  'IDS_MORE_SETTING_DLG_UR': {
    "pos": "-1px -240px",
    "defaultVal": 18
  },
  'IDS_MORE_SETTING_DLG_LD': {
    "pos": "-47px -242px",
    "defaultVal": 20
  },
  'IDS_MORE_SETTING_DLG_DL': {
    "pos": "-1px -288px",
    "defaultVal": 0
  },
  'IDS_MORE_SETTING_DLG_BA': {
    "pos": "-47px -283px",
    "defaultVal": 0,
    "title": "Зажмите правую и щелкните левой кнопкой мыши"
  },
  'IDS_MORE_SETTING_DLG_DR': {
    "pos": "-1px -336px",
    "defaultVal": 12
  },
  'IDS_MORE_SETTING_DLG_BC': {
    "pos": "-47px -330px",
    "defaultVal": 0,
    "title": "Нажмите и удерживайте правую и щелкните левой кнопкой"
  },
  'IDS_MORE_SETTING_DLG_RL': {
    "pos": "-1px -384px",
    "defaultVal": 14
  },
  'IDS_MORE_SETTING_DLG_BCU': {
    "pos": "-47px -378px",
    "defaultVal": 0,
    "title": "Удерживая правую кнопку, вверх колесиком"
  },
  'IDS_MORE_SETTING_DLG_LR': {
    "pos": "-1px -431px",
    "defaultVal": 12
  },
  'IDS_MORE_SETTING_DLG_BCD': {
    "pos": "-47px -426px",
    "defaultVal": 0,
    "title": "Удерживая правую кнопку, вниз колесиком"
  }
};

function UpdateMouseGeture() {
  var tpOptionsData = templateData['tpOptionsInitData'];
  for (var key in tpInitOptionsMouseGestureData) {
    var tpOptionData = tpOptionsData[key],
      options = tpOptionData['options'],
      value = tpOptionData['value'];

    var str = '',
      selected = '',
      selectEl = $('SELECT_' + key);
    options.forEach(function(option, idx) {
      selected = (value == idx) ? 'selected' : '';
      str += '<option value="' + idx + '" ' + selected + '>' + templateData[option] + '</option>';
    });
    selectEl.innerHTML = str;

    selectEl.onchange = function() {
      var k = this.id.replace('SELECT_', '');
      tpOptionsData[k].value = this.value;
      templateData['tpOptionsInitData'] = tpOptionsData;
      tpSetOptionsData(k, this.value);
    }
  }
}