// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//时间戳
Date.prototype.Format_time = function(fmt) { //author: meizz 
    var o = {
        "M+": this.getMonth() + 1, //月份 
        "d+": this.getDate(), //日 
        "H+": this.getHours(), //小时 
        "m+": this.getMinutes(), //分 
        "s+": this.getSeconds(), //秒 
        "q+": Math.floor((this.getMonth() + 3) / 3), //季度 
        "S": this.getMilliseconds() //毫秒 
    };
    if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
    for (var k in o)
        if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
    return fmt;
}
// var time1 = new Date().Format_time("yyyy-MM-dd");
// var time2 = new Date().Format_time("yyyy-MM-dd HH:mm:ss");
cr.define('options', function() {
    var OptionsPage = options.OptionsPage;

    function certificateListOverlay() {
        OptionsPage.call(this,
            'certificate',
            templateData.advancedPageTabTitle,
            'certificate-list-overlay');
    }

    cr.addSingletonGetter(certificateListOverlay);

    certificateListOverlay.prototype = {
        // Inherit from OptionsPage.
        __proto__: OptionsPage.prototype,

        /**
         * Initialize the page.
         */
        initializePage: function() {

            // Call base class implementation to start preference initialization.
            OptionsPage.prototype.initializePage.call(this);
            var self = this;

            var eles = $('certificate-list-overlay').querySelectorAll('.btn-close');
            for (var i = 0; i < eles.length; i++) {
                eles[i].onclick = function() {
                    OptionsPage.closeOverlay();
                };
            }

        },

        /**
         * onShowPage
         */
        didShowPage: function() {
            chrome.send('getRootCertList', ['certificateListOverlay.onGetList']);
        }
    };

    certificateListOverlay.onGetList = function(json) {
        // console.log(json)
        var val = json.root;
        if (val.length > 0) {
            var cf = []
            for (var i = 0; i < val.length; i++) {
                cf.push('<li><div class="t"><i></i><a href="#">' + val[i]['organization'] + '</a></div><div class="txt" style="display:none">')
                // console.log(val[i]['organization']);
                val[i]['certificate'].forEach(function(item) {
                    cf.push('<a href="#" data-finger="' + item['finger'] + '"><span class="c_name">' + item['common'] + '</span><span class="c_time">' + new Date(Number(item['start'])).Format_time("yyyy/MM/dd") + '-' + new Date(Number(item['expiry'])).Format_time("yyyy/MM/dd") + '</span></a>')
                    // console.log(item);
                })
                cf.push('</div></li>');
            }
        }
        var listWrap = $$('#certificate-list-overlay .certificate_lists .certificate_l ul')[0];
        listWrap.innerHTML = cf.join('');
        var eles = listWrap.querySelectorAll('li div.t');
        for (var i = 0; i < eles.length; i++) {
            eles[i].onclick = function() {
                var display = this.nextSibling.style.display;
                if (display == 'none') {
                    this.nextSibling.style.display = "block";
                    this.querySelectorAll("i")[0].classList.add("hover");
                } else {
                    this.nextSibling.style.display = "none"
                    this.querySelectorAll("i")[0].classList.remove("hover");
                }

            };
        }
        var elesC = listWrap.querySelectorAll('li div.txt a');
        for (var i = 0; i < elesC.length; i++) {
            elesC[i].ondblclick = function() {
                // console.log(this.getAttribute('data-finger'))
                chrome.send('showRootCert', [this.getAttribute('data-finger')]);
            };
            //选中的效果
            // elesC[i].onclick = function() {
            //   for(var j=0;j<elesC.length;j++){
            //     elesC[j].classList.remove("clicks");
            //   }        
            // this.classList.add("clicks");
            // };
        }
    };

    // Export
    return {
        certificateListOverlay: certificateListOverlay
    };
});