﻿/**
 * define Speedup Options : Third Party UI Options Page
 *
 ***/
cr.define('options', function() {
  var OptionsPage = options.OptionsPage;

  function AppStore() {
    OptionsPage.call(this, 'appstore', templateData.appstorePageTabTitle, 'appstorePage');
  }

  cr.addSingletonGetter(AppStore);

  AppStore.prototype = {
    __proto__: options.OptionsPage.prototype,

    initializePage: function() {
      var self = this;
      OptionsPage.prototype.initializePage.call(this);

      // var title = $$('#appstorePageNav').text();
      // $$('#appstorePageNav').html('<h5><i></i>' + title + '</h5><em></em>');
      // $$('#appstorePageNav').addClass('show-top1');
      this.renderAppData();

      var _appstore_install_timer = {};

      $$('#appstorePage').delegate('.appwrap', 'click', function() {
        var crx_id = $$(this).attr('crx_id');
        var $link = $$('<a href="' + crx_id + '" target="_blank"></a>');
        $link[0].click();
      }).delegate('a.install', 'click', function(e) {
        var $this = $$(this);
        var crx = $this.attr('crx');
        if (/\.crx$/i.test(crx)) {
          e.stopPropagation();

          var crx_id = $this.parents('.appwrap').attr('crx_id');
          var $link = $$('<a href="' + crx + '"></a>');
          $link[0].click();
          $this.attr('class', 'installing');
          _appstore_install_timer[crx_id] = setTimeout(function() {
            $this.attr('class', 'install');
          }, 10 * 1000);
        }
      });

      function setInstallState(crx_id, state) {
        $$('#appstorePage .appwrap[crx_id="' + crx_id + '"] a').attr('class', state);
      }

      window.onExtensionInstalled = function(crx_id) {
        clearTimeout(_appstore_install_timer[crx_id]);
        delete _appstore_install_timer[crx_id];
        setInstallState(crx_id, 'installed');
      };
      window.onExtensionUninstalled = function(crx_id) {
        setInstallState(crx_id, 'install');
      };
      window.getAllExtensionsCallback = function(list) {
        var firstAppInstalled = false;
        list.forEach(function(crx_id) {
          setInstallState(crx_id, 'installed');
          if (self.firstAppData && self.firstAppData.crx_id == crx_id) {
            firstAppInstalled = true;
          }
        });

        if (self.firstAppData && !firstAppInstalled) {
          $$('#appstore-notify-overlay .action-area-center :checkbox').data('crx', self.firstAppData.filename).parents('.checkbox').show();
        } else {
          $$('#appstore-notify-overlay .action-area-center :checkbox')[0].checked = false;
        }
      };
    },

    /**
     * onShowPage
     */
    didShowPage: function() {
      if (localStorage['_appstore_notify_showed'] != '1') {
        localStorage['_appstore_notify_showed'] = '1';
        OptionsPage.navigateToPage("");
      }
    },

    renderAppData: function() {
      var self = this;
      $$.ajax({
        url: '',
        dataType: 'json',
        timeout: 30 * 1000,
        success: function(data) {
          if (data.errno == 0) {
            data = data.errmsg;
            if (data.recommend && data.recommend.length > 0) {
              self.firstAppData = data.recommend[0];
            }
            // var title = $$.trim(data.title);
            // if (title) {
            //   $$('#appstorePageNav em').html(title);
            //   $$('#appstorePageNav').addClass('show-top1');
            // }

            var tplFn = doT.template('\
              {{~ it :p:i }}\
              <div class="appwrap" crx_id="{{!p.crx_id}}">\
                        <img src="{{!p.logo}}">\
                        <h3>{{!p.name}}</h3>\
                        <div class="intro">{{!p.shortdesc}}</div>\
                        <a class="install" href="javascript:;" crx="{{!p.filename}}"></a>\
                    </div>\
              {{~}}');

            // $$('#appstorePage .recommend > div').html(tplFn(data.recommend));
            $$('#appstorePage .other > div').html(tplFn(data.recommend));
            $$('#appstorePage .displaytable').removeAttr('hidden');
            chrome.send('getAllExtensions');
          } else {
            $$('').removeAttr('hidden');
          }
        },
        error: function() {
          $$('').removeAttr('hidden');
        }
      });
    }
  };

  return {
    AppStore: AppStore
  };
});
