﻿/**
 * define adfilterOptions
 *
 ***/
cr.define('options', function () {
    var OptionsPage = options.OptionsPage;

    function ADFilterOptions() {
        OptionsPage.call(this, 'adfilter', templateData.adFilterPageTabTitle, 'adfilterPage');
    }

    cr.addSingletonGetter(ADFilterOptions);

    ADFilterOptions.prototype = {
        __proto__: options.OptionsPage.prototype,

        initializePage: function () {
            OptionsPage.prototype.initializePage.call(this);
            $("manageadFilterExceptionBtn").addEventListener("click", function (e) {
                OptionsPage.navigateToPage('adfilterException');
            });
            $("enablePopWinFilter").addEventListener("click", function (e) {
                var allow = (this.checked) ? "block" : "allow";
                var selector = 'input[type=radio][name=popups][value=' + allow + ']';
                document.querySelector(selector).click();
            });

            // 查询是否显示
            chrome.send('showBlockSoft', ['adFilterOptions.showBlockSoft']);
            // 点击按钮调接口
            $('btnSoftBlockSettings').addEventListener('click', function(){
                chrome.send('blockSoftAdvance');
            });

        } //initializePage
    };

    // 查询是否显示回调函数
    ADFilterOptions.showBlockSoft = function(show) {
      $('optSoftBlock').style.display = show ? 'block' : 'none';
    };

    return {
        ADFilterOptions: ADFilterOptions
    };
});
